import React from "react";
import Navbar from "@/component/shared/Navbar";
import Link from "next/link";

const AccountPage = () => {
    return (
        <>
            <Navbar />

            {/* Main Content */}
            <main className="max-w-7xl mx-auto px-4 sm:px-6 md:px-8 text-gray-900">
                <p className="text-sm mb-2 text-gray-700">
                    Home &gt;{" "}
                    <a href="#" className="text-blue-800 hover:underline">
                        Your account
                    </a>
                </p>
                {/* Top info line */}
                <p className="text-sm text-right mb-3">
                    Signed in as < >SAIDUL ISLAM MOZUMDER</ >
                    <br/>
                    <a href="#" className="text-blue-800  underline ml-2">
                        Account home
                    </a>{" "}
                    |{" "}
                    <a href="#" className="text-blue-800  underline">
                        Account profile
                    </a>{" "}
                    |{" "}
                    <a href="#" className="text-[#182838]  underline">
                        Help
                    </a>{" "}
                    |{" "}
                    <a href="#" className="text-[#182838]  underline">
                        Logout
                    </a>
                </p>

                {/* Main heading */}
                <h1 className="text-[1.8rem] md:text-[2rem] font-bold mb-6 border-b border-red-500 pb-1">
                    SAIDUL ISLAM MOZUMDER&apos;s account
                </h1>

                {/* View applications section */}
                <section className="mb-10">
                    <h2 className="text-2xl md:text-2xl font-semibold mb-2">
                        View the applications you submitted
                    </h2>
                    <p className="text-base text-gray-800 mb-3">
                        Review, check the status or read messages about your submitted
                        application.
                    </p>

                    {/* Table controls */}
                    <div className="flex flex-col md:flex-row md:items-center md:justify-between mb-2 text-sm">
                        <div>
                            <label htmlFor="search" className="mr-1 font-semibold">
                                Search:
                            </label>
                            <input
                                id="search"
                                type="text"
                                className="border border-gray-400 px-1 py-[2px] rounded-sm w-40 text-sm"
                            />
                        </div>
                        <div className="mt-2 md:mt-0 flex items-center gap-1">
                            <label htmlFor="entries" className="font-semibold">
                                Show
                            </label>
                            <select
                                id="entries"
                                className="border border-gray-400 rounded-sm text-sm px-1 py-[1px]"
                            >
                                <option>5</option>
                                <option>10</option>
                            </select>
                            <span className="font-bold">entries</span>
                        </div>
                    </div>

                    {/* Table */}
                    <div className="overflow-x-auto">
                        <table className="w-full text-sm border-collapse">
                            <thead className="bg-gray-100 border-b border-gray-400">
                            <tr>
                                <th className="px-2 py-2 text-left font-semibold">Application type</th>
                                <th className="px-2 py-2 text-left font-semibold">Application number</th>
                                <th className="px-2 py-2 text-left font-semibold">Applicant name</th>
                                <th className="px-2 py-2 text-left font-semibold">Date submitted</th>
                                <th className="px-2 py-2 text-left font-semibold">Current status</th>
                                <th className="px-2 py-2 text-left font-semibold">Messages</th>
                                <th className="px-2 py-2 text-left font-semibold">Action</th>
                            </tr>
                            </thead>
                            <tbody>
                            <tr className="border-t border-gray-300">
                                <td className="px-2 py-2">Online Application</td>
                                <td className="px-2 py-2">V351943625</td>
                                <td className="px-2 py-2">SAIDUL ISLAM MOZUMDER</td>
                                <td className="px-2 py-2">September 30, 2025</td>
                                <td className="px-2 py-2">Submitted</td>
                                <td className="px-2 py-2">Read</td>
                                <td className="px-2 py-2">
                                    <Link
                                        href="/status"
                                        className="text-blue-800 hover:underline text-sm"
                                    >
                                        Check full application status
                                    </Link>
                                </td>
                            </tr>
                            </tbody>
                        </table>
                    </div>

                    {/* Pagination */}
                    <div className="flex justify-center mt-3">
                        <span className="border border-gray-400 bg-blue-800 text-white px-3 py-[2px] rounded text-sm">
                            1
                        </span>
                    </div>

                    {/* Note */}
                    <p className="mt-4 text-sm text-gray-800">
                        Did you apply on paper or don&apos;t see your online application in
                        your account?{" "}
                        <a href="#" className="#182838  underline">
                            Add (link) your application to your account
                        </a>{" "}
                        to access it and check your status online.
                    </p>
                </section>

                {/* Continue an application section */}
                <section className="mb-10">
                    <h2 className="text-xl md:text-xl font-semibold mb-2">
                        Continue an application you haven&apos;t submitted
                    </h2>
                    <p className="text-base text-gray-800 mb-3">
                        Continue working on an application or profile you haven&apos;t
                        submitted or delete it from your account.
                    </p>

                    {/* Table controls */}
                    <div className="flex flex-col md:flex-row md:items-center md:justify-between mb-2 text-sm">
                        <div>
                            <label htmlFor="search" className="mr-1 font-semibold">
                                Search:
                            </label>
                            <input
                                id="search"
                                type="text"
                                className="border border-gray-400 px-1 py-[2px] rounded-sm w-40 text-sm"
                            />
                        </div>
                        <div className="mt-2 md:mt-0 flex items-center gap-1">
                            <label htmlFor="entries" className="font-semibold">
                                Show
                            </label>
                            <select
                                id="entries"
                                className="border border-gray-400 rounded-sm text-sm px-1 py-[1px]"
                            >
                                <option>5</option>
                                <option>10</option>
                            </select>
                            <span className="font-bold">entries</span>
                        </div>
                    </div>

                    <div className="overflow-x-auto">
                        <table className="w-full text-sm border-collapse">
                            <thead className="bg-gray-100 border-b border-gray-400">
                            <tr>
                                <th className="px-2 py-2 text-left font-semibold">Application type</th>
                                <th className="px-2 py-2 text-left font-semibold">Date Created</th>
                                <th className="px-2 py-2 text-left font-semibold">Days left to submit</th>
                                <th className="px-2 py-2 text-left font-semibold">Date last saved</th>
                                <th className="px-2 py-2 text-left font-semibold">Action</th>
                            </tr>
                            </thead>
                            <tbody>
                            <tr className="border-t border-gray-300">
                                <td
                                    className="px-2 py-3 text-center text-gray-600"
                                    colSpan={5}
                                >
                                    No data available in table
                                </td>
                            </tr>
                            </tbody>
                        </table>
                    </div>
                </section>

                {/* Start an application */}
                <section className="mb-10">
                    <h2 className="text-2xl md:text-xl font-semibold mb-3">
                        Start an application
                    </h2>
                    <div className="grid grid-cols-1 md:grid-cols-3 gap-6 text-sm">
                        <div>
                            <a href="#" className="text-[#182838] text-base  underline font-bold">
                                Apply to come to Canada
                            </a>
                            <p className="text-gray-800 mt-2">
                                Includes applications for visitor visas, work and study permits,
                                Express Entry and International Experience Canada. You will need
                                your personal reference code if you have one.
                            </p>
                            <p className="text-gray-800 mt-2">
                                Note: You <strong>must </strong>
                                apply through this portal (IRCC secure account)
                                if you&apos;re applying with a family member who needs a work
                                permit.
                            </p>
                        </div>

                        <div>
                            <a href="#" className="text-[#182838] text-base  underline font-bold">
                                Refugees: Apply for temporary health care benefits
                            </a>
                            <p className="text-gray-800 mt-2">
                                Use this application if you are a protected person or refugee
                                claimant who wants to apply for the Interim Federal Health
                                Program.
                            </p>
                        </div>

                        <div>
                            <a href="#" className="text-[#182838] text-base  underline font-bold">
                                Citizenship: Apply for a search or proof of citizenship
                            </a>
                            <p className="  mt-2">
                                Use this application to apply for proof of citizenship
                                (citizenship certificate) or to search citizenship records.
                            </p>
                        </div>
                    </div>
                </section>

                {/* Account messages */}
                <section className="mb-8">
                    <h2 className="text-xl md:text-xl font-semibold mb-2">
                        Account messages
                    </h2>
                    <p className="text-sm text-gray-800">
                        Read messages related to your account. Messages about a submitted
                        application are on your application status page.
                    </p>
                    <p className="text-sm text-gray-800 mt-1">You have no messages.</p>
                </section>

                {/* Report button */}
                <div className="mt-6">
                    <button className="border border-gray-600 text-gray-800 px-4 py-2 text-sm rounded hover:bg-gray-100">
                        Report a problem or mistake on this page
                    </button>
                </div>

                <p className="text-sm text-gray-800 mt-4">Date modified: 2025-07-31</p>
            </main>

            {/* Footer */}
            <footer className="mt-auto border-t border-gray-200 bg-[#182838] text-gray-100">
                <div className="mx-auto max-w-7xl px-4 py-8">
                    <ul className="grid grid-cols-1 gap-3 text-[15px] md:grid-cols-2 lg:grid-cols-3">
                        <li><a className="hover:underline" href="#">Contact us</a></li>
                        <li><a className="hover:underline" href="#">Departments and agencies</a></li>
                        <li><a className="hover:underline" href="#">Public service and military</a></li>
                        <li><a className="hover:underline" href="#">News</a></li>
                        <li><a className="hover:underline" href="#">Treaties, laws and regulations</a></li>
                        <li><a className="hover:underline" href="#">Government-wide reporting</a></li>
                        <li><a className="hover:underline" href="#">Prime Minister</a></li>
                        <li><a className="hover:underline" href="#">About government</a></li>
                        <li><a className="hover:underline" href="#">Open government</a></li>
                    </ul>
                </div>
            </footer>

            <div className="py-6 bg-white text-sm mx-auto max-w-7xl text-[#182838] flex justify-between items-end lg:justify-between lg:items-center">
                <div className="px-2">
                    <ul className="flex flex-col lg:flex-row gap-x-6 gap-y-3">
                        <li><a className="hover:underline" href="#">Social media</a></li>
                        <li><a className="hover:underline" href="#">Mobile applications</a></li>
                        <li><a className="hover:underline" href="#">About Canada.ca</a></li>
                        <li><a className="hover:underline" href="#">Terms and conditions</a></li>
                        <li><a className="hover:underline" href="#">Privacy</a></li>
                    </ul>
                </div>
                <span className="relative text-5xl font-serif font-bold text-black leading-none">
                    Canada
                    <span className="absolute -top-1 right-[-4px] inline-block">
                        <img
                            src="https://upload.wikimedia.org/wikipedia/commons/d/d9/Flag_of_Canada_%28Pantone%29.svg"
                            alt="Canada Flag"
                            className="w-7 h-7"
                        />
                    </span>
                </span>
            </div>
        </>
    );
};

export default AccountPage;
