import React from 'react';
import NavbarCommon from "@/component/shared/NavbarCommon";
import { PageFooter } from "@/app/twofactauth/page";
import Link from "next/link";

const Page = () => {
    return (
        <>
            <NavbarCommon />

            {/* dark strip heading right after navbar */}
            <div className="w-full bg-[#2d4b6a] text-white">
                <div className="max-w-7xl mx-auto px-6 md:px-8 py-3">
                    <h2 className="text-2xl md:text-3xl font-bold">
                        Two-factor authentication
                    </h2>
                </div>
            </div>

            {/* sub-nav bar — screenshot style */}
            <div className="w-full bg-[#e9edf1] border-t-[3px] border-[#2d4b6a] border-b">
                <div className="max-w-7xl mx-auto px-6 md:px-8">
                    <nav aria-label="Secondary">
                        <ul className="flex text-sm font-semibold text-[#2d4b6a] divide-x divide-gray-300">
                            <li className="border-l border-gray-300">
                                <a
                                    href="#"
                                    className="block px-6 py-3 hover:underline focus:underline focus:outline-none"
                                >
                                    Contact us
                                </a>
                            </li>
                            <li>
                                <a
                                    href="#"
                                    className="block px-6 py-3 hover:underline focus:underline focus:outline-none"
                                >
                                    FAQ
                                </a>
                            </li>
                            <li>
                                <a
                                    href="#"
                                    className="block px-6 py-3 hover:underline focus:underline focus:outline-none"
                                >
                                    Help
                                </a>
                            </li>
                            {/* spacer to push items left like the screenshot */}
                            <li className="flex-1" />
                        </ul>
                    </nav>
                </div>
            </div>

            {/* main content */}
            <main className="max-w-7xl mx-auto px-6 md:px-8 py-8 md:py-10">
                <section >
                    {/* Page title + thin red rule */}
                    <h1 className="text-3xl font-bold text-gray-900">
                        Two-factor authentication setup complete
                    </h1>
                    <div className="mt-2 h-[2px] w-full bg-[#a71e32]" />

                    {/* Success row with green check and short vertical line above it */}
                    <div className="mt-6 flex items-start">
                        <div className="mr-4 flex flex-col items-center">
                            <div className="h-8 w-[4px] bg-green-700 rounded" />
                            <div className="mt-2">
                                {/* green check circle */}
                                <svg
                                    viewBox="0 0 24 24"
                                    className="h-8 w-8 text-green-700"
                                    aria-hidden="true"
                                >
                                    <circle cx="12" cy="12" r="10" fill="currentColor" />
                                    <path
                                        d="M9.2 16.2L5.7 12.7l1.4-1.4 2.1 2.1 7.1-7.1 1.4 1.4-8.5 8.5z"
                                        fill="#fff"
                                    />
                                </svg>
                            </div>
                        </div>

                        <div>
                            <h2 className="text-2xl font-bold text-gray-900">Setup complete</h2>
                            <p className="mt-2 text-gray-800">
                                You have successfully set up a two-factor authentication.
                            </p>
                        </div>
                    </div>

                    {/* Details */}
                    <div className="mt-8 text-gray-800">
                        <p>Here are the details of your two-factor authentication recent activity:</p>
                        <ul className="mt-3 list-disc pl-6 space-y-2">
                            <li>
                                Your last two-factor authentication was on{" "}
                                <span className="font-semibold">
                  Saturday, October 4, 2025 at 11:29:47 EDT
                </span>
                            </li>
                            <li>
                                You have <span className="font-bold">5</span> active recovery codes remaining
                            </li>
                        </ul>
                    </div>

                    {/* Continue button */}
                    <div className="mt-6">
                       <Link href={"/termandconditions"}>
                           <button
                               type="button"
                               className="inline-flex items-center rounded bg-[#2d4b6a] px-4 py-2 text-sm font-semibold text-white shadow-sm hover:bg-[#244059] focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-[#2d4b6a]"
                           >
                               Continue
                           </button>
                       </Link>
                    </div>

                    <div className={"flex flex-col items-start justify-center my-3"}>
                        <p className={"text-gray-700 "}>
                            To change your device or method of two factor authentication, select the button below to return to the setup process.
                        </p>
                       <Link href={"/twofactauth"}>
                           <button className={"my-1 bg-gray-300 px-2 py-1 shadow-2xl text-[#2d4b6a] hover:bg-gray-400 transition-all duration-300 ease-linear rounded"}>
                               Change your two-factor authentication
                           </button>
                       </Link>
                    </div>

                    <div className={"flex flex-col items-start justify-center my-3"}>
                        <p className={"text-gray-700 "}>
                           If you have lost or are running out of recovery codes, select the button below to get new set of codes.
                        </p>
                        <button className={"my-1 bg-gray-300 px-2 py-1 shadow-2xl text-[#2d4b6a] hover:bg-gray-400 transition-all duration-300 ease-linear rounded"}>
                            Get new recovery codes
                        </button>
                    </div>


                    {/* footer meta line */}
                    <p className="mt-10 text-sm text-gray-600">Date modified: 2024-06-15</p>
                </section>
            </main>

            <PageFooter />
        </>
    );
};

export default Page;
