"use client";

import React, { useEffect, useState } from "react";
import { useRouter, useSearchParams } from "next/navigation";
import NavbarCommon from "@/component/shared/NavbarCommon";
import { PageFooter } from "@/app/twofactauth/page";

const EmailConfirmation = () => {
    const router = useRouter();



    const handleSubmit = (e: React.FormEvent<HTMLFormElement>) => {
        e.preventDefault();
        const form = e.currentTarget;
        if (!form.checkValidity()) {
            form.reportValidity();
            return;
        }
        router.push("/complete ");
    };

    return (
        <>
            <NavbarCommon />

            {/* dark strip heading right after navbar */}
            <div className="w-full bg-[#2d4b6a] text-white">
                <div className="max-w-7xl mx-auto px-6 md:px-8 py-3">
                    <h2 className="text-2xl md:text-3xl font-bold">
                        Two-factor authentication
                    </h2>
                </div>
            </div>

            {/* sub-nav bar — screenshot style */}
            <div className="w-full bg-[#e9edf1] border-t-[3px] border-[#2d4b6a] border-b">
                <div className="max-w-7xl mx-auto px-6 md:px-8">
                    <nav aria-label="Secondary">
                        <ul className="flex text-sm font-semibold text-[#2d4b6a] divide-x divide-gray-300">
                            <li className="border-l border-gray-300">
                                <a
                                    href="#"
                                    className="block px-6 py-3 hover:underline focus:underline focus:outline-none"
                                >
                                    Contact us
                                </a>
                            </li>
                            <li>
                                <a
                                    href="#"
                                    className="block px-6 py-3 hover:underline focus:underline focus:outline-none"
                                >
                                    FAQ
                                </a>
                            </li>
                            <li>
                                <a
                                    href="#"
                                    className="block px-6 py-3 hover:underline focus:underline focus:outline-none"
                                >
                                    Help
                                </a>
                            </li>
                            <li className="flex-1" />
                        </ul>
                    </nav>
                </div>
            </div>

            {/* main content */}
            <main className="max-w-7xl mx-auto px-6 md:px-8 py-8 md:py-10">
                <section className=" ">
                    {/* heading + thin red rule */}
                    <h1 className="text-3xl font-bold text-gray-900">
                        Verify your email address
                    </h1>
                    <div className="mt-2 h-[2px] w-full bg-[#a71e32]" />

                    {/* explanatory copy */}
                    <p className="mt-6 text-gray-800">
                        An email with a one-time passcode has been sent to{" "}
                        <span className="font-semibold">****@gmail.com</span>. Copy or enter the
                        code from that email into the field below to finish registering your
                        email address. The code will expire after 20 minutes.
                    </p>
                    <p className="mt-4 text-gray-800">
                        The one-time passcode is case sensitive.
                    </p>

                    {/* form */}
                    <form onSubmit={handleSubmit} className="mt-6 space-y-6">
                        <div>
                            <label
                                htmlFor="otp"
                                className="block text-base font-semibold text-gray-900"
                            >
                <span className="text-red-600 mr-1" aria-hidden="true">
                  *
                </span>
                                One-time passcode
                                <span className="font-normal text-gray-600">
                  {" "}
                                    (Required field)
                </span>
                            </label>
                            <input
                                id="otp"
                                name="otp"
                                type="text"
                                required
                                className="mt-2 block w-full max-w-xs rounded border border-gray-300 px-3 py-2 text-gray-900 shadow-sm placeholder-gray-400 focus:outline-none focus:ring-2 focus:ring-[#2d4b6a] focus:border-[#2d4b6a]"
                            />
                        </div>

                        <div>
                            <button
                                type="submit"
                                className="inline-flex items-center rounded bg-[#2d4b6a] px-4 py-2 text-sm font-semibold text-white shadow-sm hover:bg-[#244059] focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-[#2d4b6a]"
                            >
                                Continue
                            </button>
                        </div>
                    </form>

                    {/* help block */}
                    <div className="mt-8">
                        <h3 className="text-xl font-bold text-gray-900">
                            Did not receive your one-time passcode or it has expired?
                        </h3>
                        <p className="mt-3 text-gray-800">
                            Please wait at least 2 minutes for the email to arrive and check
                            that the email is not in your spam folder.
                        </p>

                        <div className="mt-4">
                            <button
                                type="button"
                                className="inline-flex items-center rounded border border-gray-300 bg-gray-100 px-4 py-2 text-sm font-medium text-gray-800 hover:bg-gray-200 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-[#2d4b6a]"
                            >
                                Resend code
                            </button>
                        </div>
                    </div>

                    {/* secondary actions */}
                    <div className="mt-5 flex items-center gap-3">
                        <a
                            href="#"
                            role="button"
                            className="inline-flex items-center rounded border border-gray-300 bg-gray-100 px-4 py-2 text-sm font-medium text-gray-800 hover:bg-gray-200 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-[#2d4b6a]"
                        >
                            Back
                        </a>
                        <a
                            href="#"
                            role="button"
                            className="inline-flex items-center rounded border border-gray-300 bg-gray-100 px-4 py-2 text-sm font-medium text-gray-800 hover:bg-gray-200 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-[#2d4b6a]"
                        >
                            Cancel
                        </a>
                    </div>

                    {/* footer meta line */}
                    <p className="mt-10 text-sm text-gray-600">
                        Date modified: 2024-06-15
                    </p>
                </section>
            </main>

            <PageFooter />
        </>
    );
};

export default EmailConfirmation;
