'use client';

import { useEffect } from 'react';

export default function ErrorPage({ error, reset }: { error: Error; reset: () => void }) {
    useEffect(() => {
        console.error(error);
    }, [error]);

    return (
        <main className="flex min-h-screen flex-col items-center justify-center bg-red-50 text-center px-6">
            <h1 className="text-5xl font-bold text-red-700 mb-4">Something went wrong</h1>
            <p className="text-gray-700 mb-8 max-w-md">
                An unexpected error occurred. Please try again or go back to the homepage.
            </p>
            <div className="flex gap-3">
                <button
                    onClick={() => reset()}
                    className="px-5 py-2.5 rounded bg-[#2d4b6a] text-white font-medium hover:bg-[#203a55] focus:outline-none focus:ring-2 focus:ring-[#2d4b6a]"
                >
                    Try Again
                </button>
                <a
                    href="/"
                    className="px-5 py-2.5 rounded border border-gray-300 text-gray-800 font-medium bg-white hover:bg-gray-100"
                >
                    Go Home
                </a>
            </div>
        </main>
    );
}
