import React from 'react';
import Navbar from "@/component/shared/Navbar";
import Link from "next/link";

const Page = () => {
    return (
        <div>

            <Navbar />
            {/* Crumbs and signed in line */}
            <div className="mx-auto max-w-7xl px-4 pt-4">
                <nav aria-label="Breadcrumb" className="text-[15px]">
                    <a href="#" className="text-[#1a5a96] underline">Home</a>
                    <span className="px-2 text-gray-500">&gt;</span>
                    <span className="text-gray-700">Identity Validation</span>
                </nav>

                <div className="mt-3 flex flex-wrap items-center justify-between gap-2 text-[15px] text-gray-700">
                    <p>
                        <span className="text-gray-600">Signed in as</span>
                        <span className="px-1 font-semibold">SAIDUL ISLAM</span>
                    </p>
                    <p className="space-x-3">
                        <a href="#" className="text-[#1a5a96] underline">Help</a>
                        <span className="text-gray-400">|</span>
                        <a href="#" className="text-[#1a5a96] underline">Logout</a>
                    </p>
                </div>
            </div>

            {/* Main */}
            <main className="mx-auto max-w-7xl px-4 pb-12 pt-4">
                <h1 className="text-3xl font-bold">Identity Validation</h1>
                <div className="mt-2 h-[2px] w-full bg-[#a71e32]" />

                <section className="mt-5 max-w-2xl text-[16px] text-gray-800">
                    <p>For security reasons, additional identification is required to access your account.</p>
                    <p className="mt-3">Please answer the following secret question:</p>

                    <label htmlFor="secret" className="mt-4 block font-semibold">
                        <span className="text-red-600 mr-1">*</span>
                        <span className="mr-1">"my dream country to visit?"</span>
                        <span className="text-red-600">(required)</span>
                    </label>
                    <input
                        id="secret"
                        name="secret"
                        type="text"
                        autoComplete="off"
                        required={true}
                        className="mt-1 w-full rounded-md border border-gray-300 bg-white px-3 py-2 text-[16px] shadow-sm focus:border-[#1a5a96] focus:outline-none focus:ring-2 focus:ring-[#1a5a96]"
                        placeholder=""
                    />

                    <div className="mt-6 space-y-3 space-x-3">
                      <Link href={'/account'} >
                          <button
                              type="button"
                              className="w-full rounded-md bg-[#26384a] px-4 py-3 text-center text-[16px] font-semibold text-white shadow-sm hover:bg-[#1f2f3f] focus:outline-none focus:ring-2 focus:ring-[#26384a] focus:ring-offset-2 md:w-auto"
                          >
                              Continue
                          </button>
                      </Link>

                        <button
                            type="button"
                            className="w-full rounded-md border border-gray-300 bg-gray-100 px-4 py-3 text-[16px] font-medium text-gray-800 hover:bg-gray-200 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-[#26384a] md:w-auto"
                        >
                            Logout
                        </button>

                        <button
                            type="button"
                            className="w-full rounded-md border border-gray-300 bg-gray-100 px-4 py-3 text-[15px] font-medium text-gray-800 hover:bg-gray-200 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-[#26384a] md:w-auto"
                        >
                            Report a problem or mistake on this page
                        </button>
                    </div>

                    <p className="mt-10 text-sm text-gray-600">Date modified: 2025-07-31</p>
                </section>
            </main>
            <footer className="mt-auto border-t border-gray-200 bg-[#182838] text-gray-100">
                <div className="mx-auto max-w-7xl px-4 py-8">
                    <ul className="grid grid-cols-1 gap-3 text-[15px] md:grid-cols-2 lg:grid-cols-3">
                        <li><a className="hover:underline" href="#">Contact us</a></li>
                        <li><a className="hover:underline" href="#">Departments and agencies</a></li>
                        <li><a className="hover:underline" href="#">Public service and military</a></li>
                        <li><a className="hover:underline" href="#">News</a></li>
                        <li><a className="hover:underline" href="#">Treaties, laws and regulations</a></li>
                        <li><a className="hover:underline" href="#">Government‑wide reporting</a></li>
                        <li><a className="hover:underline" href="#">Prime Minister</a></li>
                        <li><a className="hover:underline" href="#">About government</a></li>
                        <li><a className="hover:underline" href="#">Open government</a></li>
                    </ul>
                </div>
            </footer>

            <div className="py-6 bg-white text-sm mx-auto max-w-7xl  text-[#182838] flex   justify-between items-end lg:justify-between lg:items-center">
                <div className=" px-2">
                    <ul className="flex flex-col lg:flex-row gap-x-6 gap-y-3">
                        <li><a className="hover:underline" href="#">Social media</a></li>
                        <li><a className="hover:underline" href="#">Mobile applications</a></li>
                        <li><a className="hover:underline" href="#">About Canada.ca</a></li>
                        <li><a className="hover:underline" href="#">Terms and conditions</a></li>
                        <li><a className="hover:underline" href="#">Privacy</a></li>
                    </ul>
                </div>
                <span className="relative text-5xl font-serif font-bold text-black leading-none">
            Canada
                    {/* Stylized red flag above the 'a' */}
                    <span className="absolute -top-1 right-[-4px] inline-block">
              <img
                  src="https://upload.wikimedia.org/wikipedia/commons/d/d9/Flag_of_Canada_%28Pantone%29.svg"
                  alt="Canada Flag"
                  className="w-7 h-7"
              />
            </span>
          </span>
            </div>
        </div>
    );
};

export default Page;




