import type { Metadata } from "next";
import { Geist, Geist_Mono } from "next/font/google";
import "./globals.css";

const geistSans = Geist({
  variable: "--font-geist-sans",
  subsets: ["latin"],
});

const geistMono = Geist_Mono({
  variable: "--font-geist-mono",
  subsets: ["latin"],
});

export const metadata: Metadata = {
    title: "Canada Immigration",
    description: "Canada immigration website - made by developer (GitHub: mdimamhose, email: mimam22.cse@bu.ac.bd)",

    openGraph: {
        title: "Canada Immigration",
        description: "Learn about visa programs, PR process, and immigration guidance.",
        siteName: "Canada Immigration",
    },
};


export default function RootLayout({
  children,
}: Readonly<{
  children: React.ReactNode;
}>) {
  return (
    <html lang="en">
      <body
        className={`${geistSans.variable} ${geistMono.variable} antialiased`}
      >

        {children}
      </body>
    </html>
  );
}
