'use client';

import Link from "next/link";

export default function NotFound() {
    return (
        <main className="flex min-h-screen flex-col items-center justify-center bg-gray-50 text-center px-6">
            <h1 className="text-5xl font-bold text-[#2d4b6a] mb-4">404</h1>
            <h2 className="text-2xl font-semibold text-gray-800 mb-2">
                Page Not Found
            </h2>
            <p className="text-gray-600 mb-8 max-w-md">
                The page you’re looking for doesn’t exist or may have been moved.
            </p>
            <Link
                href="/"
                className="px-5 py-2.5 rounded bg-[#2d4b6a] text-white font-medium hover:bg-[#203a55] focus:outline-none focus:ring-2 focus:ring-[#2d4b6a]"
            >
                Return Home
            </Link>
        </main>
    );
}
