"use client";

import React from "react";
import NavbarCommon from "@/component/shared/NavbarCommon";
import FooterCommon from "@/component/shared/FooterCommon";
import Link from "next/link";

const Page = () => {
    return (
        <>
            <NavbarCommon />
            <div className="bg-[#2d4a72] text-white text-base hidden lg:block ">
                <div className="max-w-7xl mx-auto flex ">
                    {/* Left */}
                    <div className="w-1/5 flex items-center justify-start border-r border-white/40 px-3 py-4">
                        <a href="#" className="hover:underline">Definitions</a>
                    </div>

                    {/* Middle */}
                    <div className="w-3/5 flex items-center justify-center border-r border-white/40 px-3 py-4">
                        <a href="#" className="hover:underline">Frequently Asked Questions (FAQ)</a>
                    </div>

                    {/* Right */}
                    <div className="w-1/5 flex items-center justify-end px-3 py-4">
                        <a href="#" className="hover:underline">Help</a>
                    </div>
                </div>
            </div>

            <main className="w-full text-[#26374a]">
                {/* Breadcrumb */}
                <div className={"bg-gray-100 "}> <nav className="text-sm max-w-7xl px-2 lg:px-0  mx-auto py-3 mb-6 ">
                    <a href="#" className="text-[#2d4b6a] underline hover:text-[#1e3852]">
                        Home
                    </a>
                    <span className="mx-2 text-gray-500">›</span>
                    <span>Welcome akenterprise2025</span>
                </nav>
                </div>

                <div className="max-w-7xl mx-auto  ">


                    {/* Title */}
                    <h1 className="text-3xl px-2  max-w-7xl md:text-4xl font-bold mb-6 md:mb-8 border-b-1 border-red-400  ">
                        Welcome akenterprise
                    </h1>

                    {/* Content area: left main panel + right options card */}
                    <div className="grid grid-cols-1 md:grid-cols-3 gap-8 md:gap-10 items-start">
                        {/* Left column (main content) */}
                        <section className="md:col-span-2">
                            {/* Thin accent line like in the screenshot */}
                            <div className=" bg-white">
                                <div className="p-6 md:p-7">
                                    <p className="mb-5">
                                        You last signed in with your GCKey on{" "}
                                        < >Friday, October 03, 2025 at 14:42:00 ET</ >.
                                    </p>

                                    <p className="mb-5">
                                        From this page you can{" "}
                                        <a href="#" className="text-[#2d4b6a] underline hover:text-[#1e3852]">
                                            Change Your Password
                                        </a>
                                        ,{" "}
                                        <a href="#" className="text-[#2d4b6a] underline hover:text-[#1e3852]">
                                            Change Your Recovery Questions
                                        </a>
                                        ,{" "}
                                        <a href="#" className="text-[#2d4b6a] underline hover:text-[#1e3852]">
                                            Manage Your Email Address
                                        </a>{" "}
                                        or{" "}
                                        <a href="#" className="text-[#2d4b6a] underline hover:text-[#1e3852]">
                                            Revoke Your GCKey
                                        </a>
                                        .
                                    </p>

                                    <p className="mb-5">
                                        To help protect your information, please remember to sign out and close your
                                        browser before leaving this computer unattended.
                                    </p>

                                    <p className="mb-7">
                                        Please select <strong>Continue</strong> to proceed to two-factor authentication.
                                    </p>

                                    <div className="w-full flex justify-center">
                                        <Link href={"/email"}>
                                            <button
                                                type="button"
                                                className="px-10 py-2.5  bg-[#2d4b6a] text-white hover:bg-[#1e3852] focus:outline-none focus-visible:outline focus-visible:outline-2 focus-visible:outline-offset-2 focus-visible:outline-[#2d4b6a] transition-colors"
                                            >
                                                Continue
                                            </button>
                                        </Link>
                                    </div>
                                </div>
                            </div>
                        </section>

                        {/* Right column (Options card) */}
                        <aside className="bg-white border border-gray-200 rounded-sm hidden lg:block">
                            <div className="border-b bg-gray-50 px-5 py-4 font-semibold">Options</div>
                            <ul className="px-5 py-4 leading-9">
                                <li>
                                    <a href="#" className="text-[#2d4b6a]  hover:text-[#1e3852]">
                                        Change Your Password
                                    </a>
                                </li>
                                <li>
                                    <a href="#" className="text-[#2d4b6a]  hover:text-[#1e3852]">
                                        Change Your Recovery Questions
                                    </a>
                                </li>
                                <li>
                                    <a href="#" className="text-[#2d4b6a]  hover:text-[#1e3852]">
                                        Manage Your Email Address
                                    </a>
                                </li>
                                <li>
                                    <a href="#" className="text-[#2d4b6a]  hover:text-[#1e3852]">
                                        Revoke Your GCKey
                                    </a>
                                </li>
                                <li>
                                    <a href="#" className="text-[#2d4b6a]  hover:text-[#1e3852]">
                                        Sign Out
                                    </a>
                                </li>
                            </ul>
                        </aside>
                    </div>

                    {/* Date modified */}
                    <p className="text-sm text-gray-700 mt-10">Date modified: 2024-07-21</p>
                </div>
            </main>

            <FooterCommon />
        </>
    );
};

export default Page;
