"use client";

import React from "react";
import { useRouter } from "next/navigation";
import FooterCommon from "@/component/shared/FooterCommon";
import NavbarCommon from "@/component/shared/NavbarCommon";

export default function GCKeyLogin() {
    const router = useRouter();

    // Submit only when the form is valid; then route to /profile
    const handleSubmit = (e: React.FormEvent<HTMLFormElement>) => {
        e.preventDefault();
        const form = e.currentTarget;
        if (!form.checkValidity()) {
            form.reportValidity(); // show native "required" prompts
            return;
        }
        router.push("/profile");
    };

    // Make the "Clear All" buttons actually clear the inputs
    const handleReset = (e: React.MouseEvent<HTMLButtonElement>) => {
        const form = e.currentTarget.closest("form") as HTMLFormElement | null;
        form?.reset();
    };

    return (
        <>
            <NavbarCommon />
            <div className="bg-white font-sans  flex flex-col text-[#000]">
                {/* Top Nav */}
                <div className="bg-[#2d4a72] text-white text-base hidden lg:block ">
                    <div className="max-w-7xl mx-auto flex ">
                        {/* Left */}
                        <div className="w-1/5 flex items-center justify-start border-r border-white/40 px-3 py-4">
                            <a href="#" className="hover:underline">
                                Definitions
                            </a>
                        </div>

                        {/* Middle */}
                        <div className="w-3/5 flex items-center justify-center border-r border-white/40 px-3 py-4">
                            <a href="#" className="hover:underline">
                                Frequently Asked Questions (FAQ)
                            </a>
                        </div>

                        {/* Right */}
                        <div className="w-1/5 flex items-center justify-end px-3 py-4">
                            <a href="#" className="hover:underline">
                                Help
                            </a>
                        </div>
                    </div>
                </div>

                {/* Breadcrumb */}
                <div className="max-w-7xl w-full mx-auto mt-[14px] px-2 text-sm text-[#444]">
                    Home ➔ Sign In / Sign Up
                </div>

                {/* Title */}
                <div className="max-w-7xl w-full mx-auto mt-[6px] px-2">
                    <h1 className="text-[22px] font-bold text-[#333] border-b border-[#b22222] pb-[4px]">
                        Welcome to GCKey
                    </h1>
                </div>

                {/* Main Box */}
                <div className={" px-2"}>
                    <div className="max-w-7xl w-full mx-auto flex flex-col lg:flex-row border border-[#bbb] py-4   mt-[22px]">
                        {/* Left Side (mobile intro copy) */}
                        <div className={"block lg:hidden px-[32px]  "}>
                            <h2 className=" font-bold text-2xl">Simple Secure Access</h2>
                            <p className="mt-[12px] text-[14px] text-[#333]">
                                A simple way to securely access Government of Canada online
                                services.
                            </p>
                            <p className="mt-[12px] text-[14px] text-[#333]">One username.</p>
                            <p className="text-[14px] text-[#333]">One password.</p>
                            <p className="mt-[12px] text-[14px] text-[#333]">
                                Your GCKey can be used to access multiple Government of Canada
                                online{" "}
                                <a href="#" className="text-[#0645ad]  underline">
                                    Enabled Services
                                </a>
                                .
                            </p>
                        </div>

                        {/* Left column: Sign in form */}
                        <div className="lg:w-2/3 lg:border-r border-[#bbb] px-[32px] py-[24px]">
                            <form onSubmit={handleSubmit}>
                                <h2 className="text-2xl font-semibold text-[#222]">
                                    Sign In
                                </h2>

                                <label className="block mt-[20px] text-sm ">
                                    Username: <span className="font-semibold ">(required)</span>
                                </label>
                                <input
                                    type="text"
                                    placeholder="Username"
                                    required
                                    className="mt-[4px] w-full border border-[#999] rounded-[2px] px-[8px] py-[6px] text-sm"
                                />

                                <label className="block mt-[20px] text-sm ">
                                    Password: <span className="font-semibold">(required)</span>
                                </label>
                                <input
                                    type="password"
                                    placeholder="Password"
                                    required
                                    className="mt-[4px] w-full border border-[#999] rounded-[2px] px-[8px] py-[6px] text-sm"
                                />

                                {/* Mobile buttons */}
                                <div className={"lg:hidden"}>
                                    <div className="flex justify-center flex-col gap-2  items-center mt-[22px] space-x-2">
                                        <button
                                            type="submit"
                                            className="bg-[#2d4a72] text-white text-sm px-14 py-[6px] rounded-[2px]"
                                        >
                                            Sign In
                                        </button>
                                        <button
                                            type="reset"
                                            onClick={handleReset}
                                            className="bg-[#eee] border border-[#999] text-sm px-12 py-[6px] rounded-[2px]"
                                        >
                                            Clear All
                                        </button>
                                        <button
                                            type="button"
                                            className="bg-[#2d4a72] text-white text-sm px-14 py-[6px] rounded-[2px]"
                                        >
                                            Sign Up
                                        </button>
                                    </div>

                                    <div className="flex flex-col justify-center items-center mt-[16px] text-[13px]  ">
                                        <a href="#" className="text-[#0645ad]   underline">
                                            Forgot your username?
                                        </a>
                                        <a href="#" className="text-[#0645ad]  underline">
                                            Forgot your password?
                                        </a>
                                    </div>
                                </div>

                                {/* Desktop buttons */}
                                <div className="lg:flex justify-center items-center mt-[22px] space-x-2 hidden  ">
                                    <button
                                        type="submit"
                                        className="bg-[#2d4a72] text-white text-sm px-[32px] py-[6px] rounded-[2px]"
                                    >
                                        Sign In
                                    </button>
                                    <button
                                        type="reset"
                                        onClick={handleReset}
                                        className="bg-[#eee] border border-[#999] text-sm px-[32px] py-[6px] rounded-[2px]"
                                    >
                                        Clear All
                                    </button>
                                </div>

                                <div className="lg:flex justify-center items-center mt-[16px] text-[13px] space-x-6 hidden">
                                    <a href="#" className="text-[#0645ad]   underline">
                                        Forgot your username?
                                    </a>
                                    <a href="#" className="text-[#0645ad]  underline">
                                        Forgot your password?
                                    </a>
                                </div>
                            </form>
                        </div>

                        {/* Right Side */}
                        <div className="lg:w-1/3 px-[32px] py-[24px] hidden lg:block">
                            <h2 className="text-[18px] font-semibold text-[#222]">
                                Simple Secure Access
                            </h2>
                            <p className="mt-[12px] text-[14px] text-[#333]">
                                A simple way to securely access Government of Canada online
                                services.
                            </p>
                            <p className="mt-[12px] text-[14px] text-[#333]">One username.</p>
                            <p className="text-[14px] text-[#333]">One password.</p>
                            <div className={"flex justify-center items-center"}>
                                <button className="bg-[#2d4a72] text-white text-sm px-10 py-3 rounded-[2px] mt-[22px]">
                                    Sign Up
                                </button>
                            </div>
                            <p className="mt-[12px] text-[14px] text-[#333]">
                                Your GCKey can be used to access multiple Government of Canada
                                online{" "}
                                <a href="#" className="text-[#0645ad] hover:underline">
                                    Enabled Services
                                </a>
                                .
                            </p>
                        </div>
                    </div>
                </div>

                {/* Exit */}
                <div className="max-w-7xl mx-auto text-center text-sm mt-[40px] px-2">
                    <p>
                        Please select <b>Exit</b> to leave the GCKey service and return to
                        the Government of Canada online service.
                    </p>
                    <button className="mt-[16px] border border-[#999] bg-[#f3f3f3] px-[40px] py-[6px] rounded-[2px]">
                        Exit
                    </button>
                </div>

                {/* Date */}

            </div>
            <div className="max-w-7xl mx-auto text-center       mt-[22px] px-2">
            <p>  Date modified: 2024-07-21</p>
        </div>

            <FooterCommon />
        </>
    );
}
