import React from "react";
import Navbar from "@/component/shared/Navbar";
import {

    FaClipboardList,
    FaUser,
    FaFile,
    FaComments,
    FaFingerprint,
    FaShieldCat,
    FaFlagCheckered

} from "react-icons/fa6";
import {FaCircleQuestion} from "react-icons/fa6";
import {LuArrowUpDown} from "react-icons/lu";
import {GoArrowDown} from "react-icons/go";

const ApplicationStatusPage = () => {
    return (
        <>
            <Navbar />

            {/* Main Content */}
            <main className="max-w-7xl mx-auto px-4 sm:px-6 md:px-8  pb-4 text-gray-900">
                {/* Breadcrumb */}
                <p className="text-sm mb-2 text-gray-700">
                    <span className={"underline"}>Home</span> &gt;{" "}
                    <a href="#" className="text-blue-800 hover:underline">
                        Your account
                    </a>
                </p>

                {/* Signed-in info */}
                <p className="text-sm text-right mb-3">
                    Signed in as < >SAIDUL ISLAM MOZUMDER</ >
                    <br/>
                    <a href="#" className="text-blue-800  underline ml-2">
                        Account home
                    </a>{" "}
                    |{" "}
                    <a href="#" className="text-blue-800  underline">
                        Account profile
                    </a>{" "}
                    |{" "}
                    <a href="#" className="text-[#182838]  underline">
                        Help
                    </a>{" "}
                    |{" "}
                    <a href="#" className="text-[#182838]  underline">
                        Logout
                    </a>
                </p>

                {/* Page heading */}
                <h1 className="text-[1.8rem] md:text-[1.8rem] font-bold mb-6 border-b border-gray-300 pb-1">
                    Application status and messages
                </h1>

                <p className="text-base text-gray-800 mb-6">
                    Check the status, review the details and read messages for your
                    application.{" "}
                    <br />
                    <a href="#" className="text-blue-950  underline text-sm">
                        View submitted application or upload documents
                    </a>
                    .
                </p>

                {/* Two-column status section */}
                <div className="grid md:grid-cols-2 gap-4 mb-10">
                    {/* Left - Application status */}
                    <div className="border border-gray-400">
                        <div className="bg-gray-100 border-b border-gray-400 px-3 py-2 font-semibold text-2xl">
                            Application status
                        </div>
                        <div className="p-3 text-sm">
                            We are processing your application. We will send you a message
                            when there is an update or if we need more information from you.
                            <br/>
                            <br/>
                            < >
                               <span className={"font-bold"}>
                                    Latest update:
                               </span>
                                <br/>
                                <span className={"font-bold"}> Final decision  - October 06, 2025: </span>
                                   Your application was approved. You need to send us your valid passport to finalize your application. Check your messages below for details.
                            </ >

                        </div>
                    </div>


                </div>

                {/* Details about application status */}
                <section className=" mb-5">
                    <h2 className="text-2xl md:text-xl font-semibold mb-3">
                        Details about your application status
                    </h2>
                    <p className="text-sm text-gray-800 mb-3">
                        When we get your application, there are a series of steps it may go
                        through before we make a decision. Use the following table to find
                        out the current status of each application step.
                    </p>

                    <ul className="  space-y-3 text-[15px] text-gray-900">
                        {/* Review of eligibility */}
                        <li>
                            <div className="flex items-start gap-2">
                                <FaClipboardList className="text-gray-700 mt-[3px] shrink-0" />
                                <div>
                                    <p className="font-semibold flex items-center gap-1">
                                        Review of eligibility <FaCircleQuestion className="text-gray-500 w-3 h-3" />
                                    </p>
                                    <p className="text-gray-800 flex items-start gap-2">
                                        <span className="text-black mt-[6px] text-[10px]">○</span>
                                        Your application is in progress. We will send you a message when we start reviewing your eligibility.
                                    </p>
                                </div>
                            </div>
                        </li>

                        {/* Review of medical results */}
                        <li>
                            <div className="flex items-start gap-2">
                                <FaUser className="text-gray-700 mt-[3px] shrink-0" />
                                <div>
                                    <p className="font-semibold flex items-center gap-1">
                                        Review of medical results <FaCircleQuestion className="text-gray-500 w-3 h-3" />
                                    </p>
                                    <p className="text-gray-800 flex items-start gap-2">
                                        <span className="text-black mt-[6px] text-[10px]">○</span>
                                        You do not need a medical exam. We will send you a message if this changes.
                                    </p>
                                </div>
                            </div>
                        </li>

                        {/* Review of additional documents */}
                        <li>
                            <div className="flex items-start gap-2">
                                <FaFile className="text-gray-700 mt-[3px] shrink-0" />
                                <div>
                                    <p className="font-semibold flex items-center gap-1">
                                        Review of additional documents <FaCircleQuestion className="text-gray-500 w-3 h-3" />
                                    </p>
                                    <p className="text-gray-800 flex items-start gap-2">
                                        <span className="text-black mt-[6px] text-[10px]">○</span>
                                        We do not need additional documents.
                                    </p>
                                </div>
                            </div>
                        </li>

                        {/* Interview */}
                        <li>
                            <div className="flex items-start gap-2">
                                <FaComments className="text-gray-700 mt-[3px] shrink-0" />
                                <div>
                                    <p className="font-semibold flex items-center gap-1">
                                        Interview <FaCircleQuestion className="text-gray-500 w-3 h-3" />
                                    </p>
                                    <p className="text-gray-800 flex items-start gap-2">
                                        <span className="text-black mt-[6px] text-[10px]">○</span>
                                        You do not need an interview. We will send you a message if this changes.
                                    </p>
                                </div>
                            </div>
                        </li>

                        {/* Biometrics */}
                        <li>
                            <div className="flex items-start gap-2">
                                <FaFingerprint className="text-gray-700 mt-[3px] shrink-0" />
                                <div>
                                    <p className="font-semibold flex items-center gap-1">
                                        Biometrics <FaCircleQuestion className="text-gray-500 w-3 h-3" />
                                    </p>
                                    <p className="text-gray-800 flex items-start gap-2">
                                        <span className="text-black mt-[6px] text-[10px]">○</span>
                                        We do not need your fingerprints. We will send you a message if this changes.
                                    </p>
                                </div>
                            </div>
                        </li>

                        {/* Background check */}
                        <li>
                            <div className="flex items-start gap-2">
                                <FaShieldCat className="text-gray-700 mt-[3px] shrink-0" />
                                <div>
                                    <p className="font-semibold flex items-center gap-1">
                                        Background check <FaCircleQuestion className="text-gray-500 w-3 h-3" />
                                    </p>
                                    <p className="text-gray-800 flex items-start gap-2">
                                        <span className="text-black mt-[6px] text-[10px]">○</span>
                                        We are processing your background check. We will send you a message if we need more information.
                                    </p>
                                </div>
                            </div>
                        </li>

                        {/* Final decision */}
                        <li>
                            <div className="flex items-start gap-2">
                                <FaFlagCheckered className="text-gray-700 mt-[3px] shrink-0" />
                                <div>
                                    <p className="font-semibold flex items-center gap-1">
                                        Final decision <FaCircleQuestion className="text-gray-500 w-3 h-3" />
                                    </p>
                                    <p className="text-gray-800 flex items-start gap-2">
                                        <span className="text-black mt-[6px] text-[10px]">○</span>
                                        October 06, 2025 Your application was approved. You need to send us your valid passport to finalize your application. Check your messages below for details.
                                    </p>
                                </div>
                            </div>
                        </li>
                    </ul>


                </section>


                {/* Messages about your application */}
                <section className="mb-10">
                    <h2 className="text-2xl md:text-xl font-semibold mb-3">
                        Messages about your application
                    </h2>
                    <p className="text-sm text-gray-800 mb-3">
                        Links and document titles are shown in the language you chose for
                        your portal account when they were generated.
                    </p>

                    {/* Search and entries control */}
                    <div className="flex flex-col md:flex-row md:items-center md:justify-between mb-2 text-sm">
                        <div>
                            <label htmlFor="search" className="mr-1 font-semibold">
                                Search:
                            </label>
                            <input
                                id="search"
                                type="text"
                                className="border border-gray-400 px-1 py-[2px] rounded-sm w-40 text-sm"
                            />
                        </div>
                        <p className={"my-1"}>
                            Showing 1 to 2 of 2 entries
                        </p>
                        <div className="mt-2 md:mt-0 flex items-center gap-1">
                            <label htmlFor="entries" className="font-semibold">
                                Show
                            </label>
                            <select
                                id="entries"
                                className="border border-gray-400 rounded-sm text-sm px-1 py-[1px]"
                            >
                                <option>10</option>
                                <option>25</option>
                            </select>
                            <span className={"font-bold"}>entries</span>
                        </div>
                    </div>

                    <div className="overflow-x-auto w-full">
                        <div className="min-w-[600px] border border-gray-400">
                            <table className="w-full text-sm border-collapse">
                                <thead className="bg-gray-100 border-b border-gray-400">
                                <tr>
                                    {/* Subject — double up/down arrow */}
                                    <th className="px-2 py-2 text-left font-semibold border-r border-gray-300 whitespace-nowrap">
                                        <div className="flex items-center gap-1">
                                            Subject
                                            <span className="flex flex-col leading-none text-gray-700">
                <LuArrowUpDown />
              </span>
                                        </div>
                                    </th>

                                    {/* Date sent — only down arrow */}
                                    <th className="px-2 py-2 text-left font-semibold border-r border-gray-300 whitespace-nowrap bg-gray-200">
                                        <div className="flex items-center gap-1">
                                            Date sent
                                            <GoArrowDown />
                                        </div>
                                    </th>

                                    {/* Date read — double up/down arrow */}
                                    <th className="px-2 py-2 text-left font-semibold whitespace-nowrap">
                                        <div className="flex items-center gap-1">
                                            Date read
                                            <span className="flex flex-col leading-none text-gray-700">
               <LuArrowUpDown />
              </span>
                                        </div>
                                    </th>
                                </tr>
                                </thead>

                                <tbody>
                                <tr className="border-t border-gray-300">
                                    <td className="px-2 py-2 border-r border-gray-300">
                                        <a
                                            href="/Original-Passport-Submission-Request-Letter.pdf"
                                            download="Original-Passport-Request.pdf"
                                            className="text-blue-800 underline hover:underline"
                                        >
                                            Original Passport Request
                                        </a>
                                    </td>

                                    <td className="px-2 py-2 border-r border-gray-300">
                                        October 06, 2025
                                    </td>
                                    <td className="px-2 py-2">October 06, 2025</td>
                                </tr>
                                {/*updated*/}
                                <tr className="border-t border-gray-300">
                                    <td className="px-2 py-2 border-r border-gray-300">
                                        <a href="#" className="text-blue-800  underline">
                                            Correspondence Letter
                                        </a>
                                    </td>
                                    <td className="px-2 py-2 border-r border-gray-300">
                                        October 06, 2025
                                    </td>
                                    <td className="px-2 py-2">October 06, 2025</td>
                                </tr>

                                <tr className="border-t border-gray-300">
                                    <td className="px-2 py-2 border-r border-gray-300">
                                        <a href="#" className="text-blue-800  underline">
                                            Submission Confirmation
                                        </a>
                                    </td>
                                    <td className="px-2 py-2 border-r border-gray-300">
                                        September 30, 2025
                                    </td>
                                    <td className="px-2 py-2">September 30, 2025</td>
                                </tr>

                                <tr className="border-t border-gray-300">
                                    <td className="px-2 py-2 border-r border-gray-300">
                                        <a href="#" className="text-blue-800  underline">
                                            Confirmation of Online Application Transmission
                                        </a>
                                    </td>
                                    <td className="px-2 py-2 border-r border-gray-300">
                                        September 30, 2025
                                    </td>
                                    <td className="px-2 py-2">September 30, 2025</td>
                                </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>



                    {/* Pagination */}
                    <div className="flex justify-center mt-3">
            <span className="border border-gray-400 bg-gray-100 px-3 py-[2px] rounded text-sm">
              1
            </span>
                    </div>
                </section>

                {/* Right - Applicant info */}
                <div className="border mb-5 border-gray-400">
                    <div className="bg-gray-100 border-b border-gray-400 px-3 py-2 font-semibold text-2xl">
                        Applicant information
                    </div>
                    <div className="p-3 text-sm space-y-1">
                        <p>
                            <strong>Principal Applicant:</strong> SAIDUL ISLAM MOZUMDER
                        </p>
                        <p>
                            <strong>Unique Client Identifier (UCI):</strong> 1139544927
                        </p>
                        <p>
                            <strong>Application number:</strong> V351943625
                        </p>
                        <p>
                            <strong>Date Received:</strong> September 30, 2025
                        </p>
                        <p>
                            <strong>Biometrics:</strong>
                        </p>
                        <div className="pl-4">
                            <p>
                                <strong>Biometrics Number:</strong> 73420241208103946
                            </p>
                            <p>
                                <strong>Date of Biometrics Enrolment:</strong> December 8, 2024
                            </p>
                            <p>
                                <strong>Expiry Date:</strong> December 8, 2034
                            </p>
                        </div>
                    </div>
                </div>

                {/* Report issue */}
                <div className="mt-6">
                    <button className="border border-gray-400 text-gray-800 bg-gray-200 px-4 py-2 text-sm rounded hover:bg-gray-100">
                        Report a problem or mistake on this page
                    </button>
                </div>

                <p className="text-sm text-gray-600 mt-4">Date modified: 2025-07-31</p>
            </main>

            <footer className="mt-auto border-t border-gray-200 bg-[#182838] text-gray-100">
                <div className="mx-auto max-w-7xl px-4 py-8">
                    <ul className="grid grid-cols-1 gap-3 text-[15px] md:grid-cols-2 lg:grid-cols-3">
                        <li><a className="hover:underline" href="#">Contact us</a></li>
                        <li><a className="hover:underline" href="#">Departments and agencies</a></li>
                        <li><a className="hover:underline" href="#">Public service and military</a></li>
                        <li><a className="hover:underline" href="#">News</a></li>
                        <li><a className="hover:underline" href="#">Treaties, laws and regulations</a></li>
                        <li><a className="hover:underline" href="#">Government‑wide reporting</a></li>
                        <li><a className="hover:underline" href="#">Prime Minister</a></li>
                        <li><a className="hover:underline" href="#">About government</a></li>
                        <li><a className="hover:underline" href="#">Open government</a></li>
                    </ul>
                </div>
            </footer>

            <div className="py-6 bg-white text-sm mx-auto max-w-7xl  text-[#182838] flex   justify-between items-end lg:justify-between lg:items-center">
                <div className=" px-2">
                    <ul className="flex flex-col lg:flex-row gap-x-6 gap-y-3">
                        <li><a className="hover:underline" href="#">Social media</a></li>
                        <li><a className="hover:underline" href="#">Mobile applications</a></li>
                        <li><a className="hover:underline" href="#">About Canada.ca</a></li>
                        <li><a className="hover:underline" href="#">Terms and conditions</a></li>
                        <li><a className="hover:underline" href="#">Privacy</a></li>
                    </ul>
                </div>
                <span className="relative text-5xl font-serif font-bold text-black leading-none">
            Canada
                    {/* Stylized red flag above the 'a' */}
                    <span className="absolute -top-1 right-[-4px] inline-block">
              <img
                  src="https://upload.wikimedia.org/wikipedia/commons/d/d9/Flag_of_Canada_%28Pantone%29.svg"
                  alt="Canada Flag"
                  className="w-7 h-7"
              />
            </span>
          </span>
            </div>

        </>
    );
};

export default ApplicationStatusPage;
