import React from "react";
import Link from "next/link";
import Navbar from "@/component/shared/Navbar";

/**
 * Government of Canada, Terms and Conditions screen (mobile first)
 * TailwindCSS only, no external assets required
 */
export default function GCTermsPage() {
    return (
        <div className="min-h-screen bg-white text-gray-900">
            {/*/!* Global header *!/*/}
            {/*<header aria-label="Government of Canada header" className="border-b border-gray-200">*/}
            {/*    <div className="mx-auto flex max-w-7xl items-center justify-between px-4 py-3">*/}
            {/*        /!* Flag + wordmark *!/*/}
            {/*        <div className="flex items-center gap-3">*/}
            {/*            /!* simple flag block *!/*/}
            {/*            <div className="h-6 w-9 overflow-hidden rounded-sm border border-gray-300">*/}
            {/*                <div className="h-full w-full bg-red-600 [background-image:linear-gradient(90deg,_#dc2626_0,_#dc2626_33%,_white_33%,_white_66%,_#dc2626_66%,_#dc2626_100%)]" />*/}
            {/*            </div>*/}
            {/*            <div className="leading-tight">*/}
            {/*                <p className="text-sm font-semibold">Government of Canada</p>*/}
            {/*                <p className="text-xs text-gray-600">Gouvernement du Canada</p>*/}
            {/*            </div>*/}
            {/*        </div>*/}

            {/*        /!* Right side icons placeholder to resemble browser chrome spacing in screenshot *!/*/}
            {/*        <div className="flex items-center gap-3 text-gray-500">*/}
            {/*<span className="inline-flex h-6 w-6 items-center justify-center rounded-full border" aria-hidden>*/}
            {/*  <span className="text-[10px]">2</span>*/}
            {/*</span>*/}
            {/*            <span className="inline-block h-1.5 w-1.5 rounded-full bg-gray-500" aria-hidden />*/}
            {/*        </div>*/}
            {/*    </div>*/}

            {/*    /!* Dark MENU strip *!/*/}
            {/*    <div className="bg-[#243b55]">*/}
            {/*        <div className="mx-auto flex max-w-7xl items-center px-4">*/}
            {/*            <button*/}
            {/*                type="button"*/}
            {/*                className="flex items-center gap-2 py-3 text-white"*/}
            {/*                aria-haspopup="true"*/}
            {/*                aria-expanded="false"*/}
            {/*            >*/}
            {/*                <span className="text-lg font-semibold">MENU</span>*/}
            {/*                <svg className="h-4 w-4" viewBox="0 0 20 20" fill="currentColor" aria-hidden>*/}
            {/*                    <path d="M5.23 7.21a.75.75 0 011.06.02L10 11.188l3.71-3.957a.75.75 0 111.08 1.04l-4.25 4.53a.75.75 0 01-1.08 0l-4.25-4.53a.75.75 0 01.02-1.06z" />*/}
            {/*                </svg>*/}
            {/*            </button>*/}
            {/*        </div>*/}
            {/*    </div>*/}
            {/*</header>
            */}
            <Navbar />

            {/* Breadcrumb row and signed-in banner */}
            <div className="mx-auto max-w-7xl px-4 pt-4">
                <nav aria-label="Breadcrumb" className="text-[15px]">
                    <a href="#" className="text-[#1a5a96] underline">Home</a>
                </nav>

                <div className="mt-4 flex flex-wrap items-center justify-between gap-2 text-[15px] text-gray-700">
                    <p>
                        <span className="text-gray-600">Signed in as</span>
                        <span className="px-1 font-semibold">SAIDUL ISLAM</span>
                    </p>
                    <a href="#" className="text-[#1a5a96] underline">Logout</a>
                </div>
            </div>

            {/* Main content */}
            <main className="mx-auto max-w-7xl px-4 pb-12 pt-4">
                <h1 className="text-3xl font-bold">Terms and Conditions</h1>
                <div className="mt-2 h-[3px] w-full bg-[#a71e32]" />

                <section className="prose prose-sm mt-6 max-w-none text-gray-800 prose-ul:mt-2">
                    <p>
                        By accessing your account, you are agreeing to abide by the following Terms and Conditions of Use:
                    </p>

                    <ul className="list-disc pl-5 text-[16px]">
                        <li>
                            You agree to keep your identification number(s) confidential and to not share it with anyone. If you suspect
                            that others have obtained your identification number(s), contact us immediately by clicking on the
                            <em> Report a problem or mistake on this page </em> button.
                        </li>
                        <li>
                            You certify that any information provided by you is true, accurate and complete.
                        </li>
                        <li>
                            You understand and accept that as a security measure for administrative reasons, we can revoke your access if you fail to abide by the Terms and Conditions of Use.
                        </li>
                        <li>
                            You understand and accept that we are not responsible for any losses or damages incurred by anyone because of the use of the information available in your account, or any restrictions, delay, malfunction, or unavailability of your account.
                        </li>
                        <li>
                            You understand and accept that by using your account and applying online, we can communicate with you or your representative via e‑mail.
                        </li>
                    </ul>

                    <p>
                        To continue, choose <strong>I Accept</strong> to indicate your acceptance of these Terms and Conditions. If you do not agree with these Terms and Conditions, choose <strong>I Do Not Accept</strong>. Note, you will not be able to access your account unless you accept the Terms and Conditions.
                    </p>

                    <p>
                        If you use another type of browser software you should check with your software supplier to make sure that your browser has 128‑bit secure socket layer encryption capability. We are not responsible for any difficulties in downloading and installing software. Software suppliers are responsible for providing technical support. It is important that you sign out and close your browser before leaving this computer unattended. This will prevent unauthorized access to your personal information.
                    </p>
                </section>

                {/* Primary actions */}
                <div className="mt-6 flex items-center gap-3">
                    <Link href="/identityvalidation" className="inline-flex">
                        <button
                            type="button"
                            className="inline-flex items-center rounded-md bg-[#27496d] px-4 py-2 text-sm font-semibold text-white shadow-sm hover:bg-[#1f3b59] focus:outline-none focus:ring-2 focus:ring-[#27496d] focus:ring-offset-2"
                        >
                            I Accept
                        </button>
                    </Link>
                    <button
                        type="button"
                        className="inline-flex items-center rounded-md border border-gray-300 bg-gray-100 px-4 py-2 text-sm font-medium text-gray-800 hover:bg-gray-200 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-[#27496d]"
                    >
                        I Do Not Accept
                    </button>
                </div>

                {/* Report a problem button */}
                <div className="mt-6">
                    <button
                        type="button"
                        className="w-full rounded-md border border-gray-300 bg-gray-100 px-4 py-3 text-[15px] font-medium text-gray-800 hover:bg-gray-200 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-[#27496d] md:w-auto"
                    >
                        Report a problem or mistake on this page
                    </button>
                </div>

                {/* Date modified line matches screenshot */}
                <p className="mt-10 text-sm text-gray-600">Date modified: 2025-07-31</p>
            </main>

            {/* Canada site footer */}
            <footer className="mt-auto border-t border-gray-200 bg-[#182838] text-gray-100">
                <div className="mx-auto max-w-7xl px-4 py-8">
                    <ul className="grid grid-cols-1 gap-3 text-[15px] md:grid-cols-2 lg:grid-cols-3">
                        <li><a className="hover:underline" href="#">Contact us</a></li>
                        <li><a className="hover:underline" href="#">Departments and agencies</a></li>
                        <li><a className="hover:underline" href="#">Public service and military</a></li>
                        <li><a className="hover:underline" href="#">News</a></li>
                        <li><a className="hover:underline" href="#">Treaties, laws and regulations</a></li>
                        <li><a className="hover:underline" href="#">Government‑wide reporting</a></li>
                        <li><a className="hover:underline" href="#">Prime Minister</a></li>
                        <li><a className="hover:underline" href="#">About government</a></li>
                        <li><a className="hover:underline" href="#">Open government</a></li>
                    </ul>
                </div>
            </footer>

                <div className="py-6 bg-white text-sm mx-auto max-w-7xl  text-[#182838] flex   justify-between items-end lg:justify-between lg:items-center">
                    <div className=" px-2">
                        <ul className="flex flex-col lg:flex-row gap-x-6 gap-y-3">
                            <li><a className="hover:underline" href="#">Social media</a></li>
                            <li><a className="hover:underline" href="#">Mobile applications</a></li>
                            <li><a className="hover:underline" href="#">About Canada.ca</a></li>
                            <li><a className="hover:underline" href="#">Terms and conditions</a></li>
                            <li><a className="hover:underline" href="#">Privacy</a></li>
                        </ul>
                    </div>
          <span className="relative text-5xl font-serif font-bold text-black leading-none">
            Canada
              {/* Stylized red flag above the 'a' */}
              <span className="absolute -top-1 right-[-4px] inline-block">
              <img
                  src="https://upload.wikimedia.org/wikipedia/commons/d/d9/Flag_of_Canada_%28Pantone%29.svg"
                  alt="Canada Flag"
                  className="w-7 h-7"
              />
            </span>
          </span>
                </div>
        </div>
    );
}
