"use client";

import React from "react";
import NavbarCommon from "@/component/shared/NavbarCommon";
import { GiMapleLeaf } from "react-icons/gi";
import Link from "next/link";

/* ---- Card component ---- */
function MethodCard({
                        title,
                        imgSrc,
                        imgAlt,
                        cta,
                        onClickHref = "/termandconditions",
                    }: {
    title: React.ReactNode;
    imgSrc: string;
    imgAlt: string;
    cta: string;
    onClickHref?: string;
}) {
    return (
        <div className="bg-white border border-gray-300 rounded-sm">
            <div className="bg-gray-100 border-b border-gray-300 px-4 py-3 text-xl text-black font-bold text-center">
                {title}
            </div>
            <div className="p-6 flex flex-col items-center text-[#26374a]">
                <img
                    src={imgSrc}
                    alt={imgAlt}
                    className="w-44 h-28 object-contain"
                    loading="lazy"
                    decoding="async"
                />
                <Link
                    href={onClickHref}
                    className="mt-5 inline-block px-5 py-2 rounded bg-gray-600 text-white hover:bg-[#1e3852] focus:outline-none focus-visible:outline focus-visible:outline-2 focus-visible:outline-offset-2 focus-visible:outline-[#2d4b6a] transition"
                >
                    {cta}
                </Link>
            </div>
        </div>
    );
}

export  function PageFooter() {
    return (
        <footer className="w-full bg-white border-t border-gray-300">
            <div className="max-w-7xl mx-auto px-6 md:px-8 py-6 flex items-center justify-between">
                {/* Left: links */}
                <div className="text-sm flex flex-col lg:flex-row">
                    <a href="#" className="text-[#2d4b6a] hover:underline">
                        Terms and conditions
                    </a>
                    <span className="mx-2 text-gray-500">•</span>
                    <a href="#" className="text-[#2d4b6a] hover:underline">
                        Privacy
                    </a>
                </div>

                {/* Right: Canada wordmark */}
                <div className="relative">
                    <span className="text-4xl font-bold font-serif text-black leading-none">Canada</span>
                    <img
                        src="https://upload.wikimedia.org/wikipedia/commons/d/d9/Flag_of_Canada_%28Pantone%29.svg"
                        alt="Canadian flag"
                        aria-hidden="true"
                        className="absolute -top-3 -right-6 w-5 h-5"
                        title="Government of Canada"
                    />
                </div>
            </div>
        </footer>
    );
}


const TwoFactAuth = () => {
    return (
        <>
            <NavbarCommon />

            {/* dark strip heading right after navbar */}
            <div className="w-full bg-[#2d4b6a] text-white">
                <div className="max-w-7xl mx-auto px-6 md:px-8 py-1">
                    <h2 className="  text-xl md:text-3xl font-bold">
                        Two-factor authentication
                    </h2>
                </div>
            </div>

            {/* sub-nav bar — screenshot style */}
            <div className="w-full bg-[#e9edf1] border-t-[3px] border-[#2d4b6a] border-b  ">
                <div className="max-w-7xl mx-auto px-6 md:px-8">
                    <nav aria-label="Secondary">
                        <ul className="flex text-sm font-semibold text-[#2d4b6a] divide-x divide-gray-300">
                            <li className="border-l border-gray-300">
                                <a
                                    href="#"
                                    className="block px-6 py-3 hover:underline focus:underline focus:outline-none"
                                >
                                    Contact us
                                </a>
                            </li>
                            <li>
                                <a
                                    href="#"
                                    className="block px-6 py-3 hover:underline focus:underline focus:outline-none"
                                >
                                    FAQ
                                </a>
                            </li>
                            <li>
                                <a
                                    href="#"
                                    className="block px-6 py-3 hover:underline focus:underline focus:outline-none"
                                >
                                    Help
                                </a>
                            </li>
                            {/* spacer to push items left like the screenshot */}
                            <li className="flex-1" />
                        </ul>
                    </nav>
                </div>
            </div>


            {/* main */}
            <main className="w-full bg-gray-100">
                <div className="max-w-7xl mx-auto px-6 md:px-8 py-10 md:py-12">
                    {/* Page title + accent rule */}
                    <h1 className="text-3xl md:text-4xl font-bold text-[#26374a]">
                        Choose a method of two-factor authentication
                    </h1>
                    <div className="mt-2 h-[1px] w-full   bg-red-400" />

                    {/* lead paragraph (Gov of Canada requirement) */}
                    <p className="mt-4 text-[#26374a] max-w-4xl">
                        <strong>The Government of Canada</strong> requires the use of two-factor authentication
                        to secure your account. You will be asked to complete registration of a second factor in
                        order to continue to access this service.
                    </p>

                    {/* Accordion / details with full text */}
                    <details open className="mt-5 bg-white border border-gray-300 rounded">
                        <summary className="px-4 py-3 cursor-pointer text-[#2d4b6a] underline hover:text-[#1e3852]">
                            What is two-factor authentication?
                        </summary>
                        <div className="px-4 pb-4 text-[#26374a] space-y-3">
                            <p>
                                Two-factor authentication is a way to confirm users, by using a combination of two
                                different factors:
                            </p>
                            <ul className="list-disc ml-6">
                                <li>something they know, such as a password</li>
                                <li>something they have, like a phone or a card</li>
                            </ul>
                            <p>
                                Think of it like a locked door that can only be opened with both a key and a secret
                                code. Someone pretending to be you on the internet should never be able to obtain
                                both the key and the code.
                            </p>
                        </div>
                    </details>

                    {/* 3 method cards */}
                    <div className="mt-6 grid grid-cols-1 md:grid-cols-3 gap-6">
                        <MethodCard
                            title={
                                <>
                                    Use your smartphone or tablet
                                </>
                            }
                            imgSrc="https://mfa.auth.canada.ca/mfaui/img/option-mobile-f7985ab0c479f2745a58a1fd676c3285.svg"
                            imgAlt="Smartphone and tablet setup illustration"
                            cta="Set up your mobile device"
                        />

                        <MethodCard
                            title="Use your desktop device"
                            imgSrc="https://mfa.auth.canada.ca/mfaui/img/option-desktop-7f6818fed94512e5f3278981ce8fa857.svg"
                            imgAlt="Desktop device setup illustration"
                            cta="Set up your desktop device"
                        />

                        <MethodCard
                            title="Use your email address"
                            imgSrc="https://mfa.auth.canada.ca/mfaui/img/option-email-8c33aa705afb70e896b4b80f1b1a5f48.svg"
                            imgAlt="Email setup illustration"
                            cta="Set up your email"
                        />
                    </div>

                    {/* Cancel + date */}
                    <div className="mt-6">
                        <button
                            type="button"
                            className="px-5 py-2 rounded border border-gray-300 bg-gray-300 text-[#26374a] hover:bg-gray-400 focus:outline-none focus-visible:outline focus-visible:outline-2 focus-visible:outline-offset-2 focus-visible:outline-[#2d4b6a] transition"
                        >
                            Cancel
                        </button>
                    </div>

                    <p className="text-sm text-gray-700 mt-8">Date modified: 2024-06-15</p>
                </div>
            </main>

            <PageFooter />
        </>
    );
};

export default TwoFactAuth;
