import React from "react";

const CanadaFooter = () => {
    return (
        <footer className="w-full">
            {/* Top Blue Section */}
            <div className="bg-[#324a62] text-white py-8">
                <div className="max-w-7xl mx-auto px-6 flex flex-col justify-center items-start gap-3 text-base">
                    <h3 className="font-bold text-2xl">Immigration and citizenship</h3>
                    <div className="flex w-full flex-col lg:fle-row space-y-3 lg:space-y-0 justify-between  text-base text-gray-100">
                        <a href="#" className="hover:underline">Contact us</a>
                        <a href="#" className="hover:underline">Check processing times</a>
                        <a href="#" className="hover:underline">How to open a form</a>
                    </div>
                </div>
            </div>


            {/* Middle Dark Blue Section */}
            <div className="relative bg-[#243447] text-white">
                <div className="max-w-7xl mx-auto px-6 py-14 grid lg:grid-cols-3 lg:gap-16 text-sm lg:text-[15px] leading-relaxed">

                    {/* Column 1 */}
                    <div className="   lg:col-span-3 text-white">
                        <h3 className="font-bold text-2xl mb-6">Government of Canada</h3>

                        {/* Responsive grid: 1 column on mobile, 2 on tablets, 3 on large screens */}
                        <ul className="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-x-8 gap-y-3 text-base md:text-lg">
                            {/* Highlighted link with underline */}
                            <li className="relative inline-block">
                                <a href="#" className="hover:underline text-white font-semibold">
                                    All contacts
                                </a>
                                <span className="absolute left-0 top-full mt-1 block w-10 h-[2px] bg-white"></span>
                            </li>

                            <li><a href="#" className="hover:underline block">Departments and agencies</a></li>
                            <li><a href="#" className="hover:underline block">About government</a></li>
                            <li><a href="#" className="hover:underline block">Jobs</a></li>
                            <li><a href="#" className="hover:underline block">Immigration and citizenship</a></li>
                            <li><a href="#" className="hover:underline block">Travel and tourism</a></li>
                            <li><a href="#" className="hover:underline block">Business</a></li>
                            <li><a href="#" className="hover:underline block">Benefits</a></li>
                            <li><a href="#" className="hover:underline block">Health</a></li>
                            <li><a href="#" className="hover:underline block">Taxes</a></li>
                            <li><a href="#" className="hover:underline block">Environment and natural resources</a></li>
                            <li><a href="#" className="hover:underline block">National security and defence</a></li>
                            <li><a href="#" className="hover:underline block">Culture, history and sport</a></li>
                            <li><a href="#" className="hover:underline block">Policing, justice and emergencies</a></li>
                            <li><a href="#" className="hover:underline block">Transport and infrastructure</a></li>
                            <li><a href="#" className="hover:underline block">Canada and the world</a></li>
                            <li><a href="#" className="hover:underline block">Money and finances</a></li>
                            <li><a href="#" className="hover:underline block">Science and innovation</a></li>
                            <li><a href="#" className="hover:underline block">Indigenous Peoples</a></li>
                            <li><a href="#" className="hover:underline block">Veterans and military</a></li>
                            <li><a href="#" className="hover:underline block">Youth</a></li>
                        </ul>
                    </div>



                </div>

                {/* Silhouette BG */}
                <div
                    className="absolute bottom-0 left-0 w-full h-[100px] bg-no-repeat bg-cover"
                    style={{ backgroundImage: "url('/parliament-silhouette.png')" }}
                ></div>
            </div>



            {/* Bottom White Bar */}
            <div className="bg-white border-t border-gray-200">
                <div className="max-w-7xl mx-auto px-6 py-6 flex justify-between items-end text-sm text-[#33465c]">
                    {/* Links */}
                    <div className="flex gap-5  flex-col lg:flex-row">
                        <a href="#" className="hover:underline">Social media</a>
                        <a href="#" className="hover:underline">Mobile applications</a>
                        <a href="#" className="hover:underline">About Canada.ca</a>
                        <a href="#" className="hover:underline">Terms and conditions</a>
                        <a href="#" className="hover:underline">Privacy</a>
                    </div>

                    {/* Canada wordmark */}
                    <div className="flex     ">
           <span className="relative text-5xl font-serif font-bold text-black leading-none">
                    Canada
                    <span className="absolute -top-2 right-[-4px] inline-block">
                        <img
                            src="https://upload.wikimedia.org/wikipedia/commons/d/d9/Flag_of_Canada_%28Pantone%29.svg"
                            alt="Canada Flag"
                            className="w-7 h-7"
                        />
                    </span>
                </span>
                    </div>
                </div>
            </div>
        </footer>
    );
};

export default CanadaFooter;
