export default function GovAccountSection() {
    return (
        <div className="max-w-7xl mx-auto px-6 py-10">
            {/* Title */}
            <h2 className="text-3xl font-semibold text-gray-900 mb-4">
                Find another government account
            </h2>

            {/* Link + paragraph */}
            <p className="text-gray-700 mb-6 lg:w-[60%]" >
                <a
                    href="#"
                    className="text-[#884cc4] underline hover:text-purple-900 font-bold"
                >
                    All Government of Canada online accounts
                </a>
                <br />
                There are many accounts across the Government of Canada for different
                services. Find the service you need.
            </p>

            {/* Feedback box */}
            <div className="bg-gray-50 border border-gray-200 rounded-md p-4 mb-6 lg:w-[60%]">
                <p className="font-medium text-center text-gray-800 mb-3">
                    Did you find what you were looking for?
                </p>
                <div className="flex justify-center items-center gap-2">
                    <button className="bg-[#243447] text-white px-4 py-1 rounded hover:bg-[#1b2935]">
                        Yes
                    </button>
                    <button className="bg-[#243447] text-white px-4 py-1 rounded hover:bg-[#1b2935]">
                        No
                    </button>
                </div>
            </div>

            {/* Date */}
            <p className="text-sm  ">Date modified: 2025-07-14</p>
        </div>
    );
}
