import React from "react";

const SignInHeader = () => {
    return (
        <section className="bg-white   px-4 sm:px-6 lg:px-8">
            <div className="max-w-7xl mx-auto">
                {/* 1. Breadcrumbs Navigation */}
                <nav aria-label="Breadcrumb">
                    <ol className="flex flex-wrap items-center text-base text-[#26374a]">
                        <li>
                            <a href="#" className="text-purple-800  underline">
                                Canada.ca
                            </a>
                        </li>
                        <li className="mx-2 font-semibold" aria-hidden="true">
                            &gt;
                        </li>
                        <li>
                            <a href="#" className="   underline">
                                Immigration and citizenship
                            </a>
                        </li>

                        <li>
                            <span className="  " aria-current="page">
                          <span className={"font-semibold"}>&gt;</span>   <span className={"underline"}>IRCC applications</span>
                            </span>
                        </li>
                    </ol>
                </nav>

                {/* 2. Main Heading Section */}
                <div className="mt-8">
                    <p className="text-2xl text-gray-500 font-semibold">Sign in</p>
                    <h1 className="text-4xl md:text-4xl font-bold text-gray-900 mt-1 tracking-tight">
                        IRCC secure account
                    </h1>
                    {/* The decorative red underline */}
                    <div className="w-24 h-1.5 bg-[#c7342c] mt-2"></div>
                </div>

                {/* 3. Content Text */}
                <div className="mt-8 space-y-5 text-lg text-gray-800">
                    <p>
                        We have different accounts for some applications.
                    </p>
                    <p>
                        <strong className="font-bold">
                            You may need a different account to apply
                        </strong>
                        , depending on the application you submit.
                    </p>
                </div>
            </div>
        </section>
    );
};

export default SignInHeader;