"use client";

import { useState } from "react";
import {
    FaKey,
    FaUniversity,
    FaUserPlus,
    FaCaretRight,
    FaCaretDown,
    FaExclamationTriangle,
    FaExclamationCircle,
} from "react-icons/fa";
import Link from "next/link";

export default function SignInSection() {
    const [openHelp, setOpenHelp] = useState(false);

    return (
        <section className="max-w-7xl mx-auto h-full mt-5 px-4">
            {/* Maintenance notice */}
            <div className="flex items-start bg-white p-4 md:p-5 rounded-sm relative">
                {/* Left orange vertical line */}
                <div className="relative flex h-full flex-col items-center mr-4">
                    {/* Continuous yellow-orange line */}
                    <div className="w-[4px] h-32 lg: lg:h-fit bg-[#f47b20] absolute top-0 bottom-0" />
                    {/* Warning icon on top of the line */}
                    <FaExclamationTriangle className=" -pb-3 z-10 text-[#f47b20] text-xl bg-white " />
                </div>

                {/* Text section */}
                <div className="flex-1">
                    <p className="text-gray-900 text-lg  ">
                        This online service will be unavailable from{" "}
                        <strong>
                            12:00 a.m. to 5:30 a.m. Tuesday, October 7, 2025, Eastern time
                        </strong>
                        , in order to perform system maintenance.
                    </p>
                </div>
            </div>

            {/* Card container */}
            <div className="my-4 border border-gray-300 bg-white shadow-sm rounded-md">
                <div className="relative grid grid-cols-1 lg:grid-cols-2 gap-6 lg:gap-10 p-6 sm:p-8">
                    {/* Left column */}
                    <div className="lg:pr-8">
                        <h2 className="text-2xl font-bold mb-4 sm:mb-6">Sign in</h2>

                        <div className="flex flex-col gap-3 w-full sm:w-11/12 mx-auto">
                            {/* GCKey Button */}
                            {/*<Link href="/signin">*/}
                                <Link href="/signin">
                                <button
                                    type="button"
                                    className="flex items-center justify-center gap-2 bg-[#26374A] hover:bg-[#1b2838] text-white px-6 py-3 w-full rounded font-semibold text-[15px] leading-snug text-center transition-all duration-200"
                                >
                                    <FaKey className="w-5 h-5" />
                                    <span>GCKey username and password</span>
                                </button>
                            </Link>

                            {/* Interac Sign-In Partner Button */}
                            <button
                                type="button"
                                className="flex items-center justify-center gap-2 bg-[#26374A] hover:bg-[#1b2838] text-white px-6 py-3 w-full rounded font-semibold text-[15px] leading-snug text-center transition-all duration-200"
                            >
                                <FaUniversity className="w-5 h-5" />
                                <span>
          Canadian <span className="italic">Interac®</span> Sign-In Partner
        </span>
                            </button>
                        </div>

                        {/* Help toggle */}
                        <div className="mt-4">
                            <button
                                type="button"
                                onClick={() => setOpenHelp((v) => !v)}
                                className="text-[#26374A] text-lg w-full border p-1 border-gray-300   flex items-center gap-1 hover:underline focus:outline-none"
                            >
                                {openHelp ? (
                                    <FaCaretDown className="w-5 h-5" />
                                ) : (
                                    <FaCaretRight className="w-5 h-5" />
                                )}
                                <span>Not sure how to sign in?</span>
                            </button>

                            {openHelp && (
                                <div className="mt-2 text-sm border border-gray-300 p-4 bg-gray-50 rounded-md">
                                    <div className="flex items-start gap-2">
                                        <FaExclamationCircle className="w-5 h-5 text-gray-600 mt-0.5 shrink-0" />
                                        <div className="space-y-3">
                                            <p>
                                                You registered with either GCKey or your Canadian banking Sign-In Partner when you
                                                created your account.
                                            </p>
                                            <p>
                                                Use the option you registered with every time you sign in. It’s tied to your account and user profile.
                                            </p>
                                            <p>If you want to choose the other sign-in option, you’ll have to register for it.</p>
                                            <p>
                                                <a href="#" className="text-blue-800 underline">
                                                    Get more help with your account
                                                </a>
                                            </p>
                                        </div>
                                    </div>
                                </div>
                            )}
                        </div>
                    </div>

                    {/* Divider */}
                    <div className="absolute hidden lg:block top-4 bottom-4 left-1/2 w-px bg-gray-400" />
                    <div className="absolute top-1/2 left-1/2 -translate-x-1/2 -translate-y-1/2 bg-white px-2">
                        <span className="hidden lg:block rounded-full border border-gray-500 px-2 py-0.5 text-gray-700 text-sm">
                            or
                        </span>
                    </div>

                    {/* Mobile divider */}
                    <div className="lg:hidden flex justify-start  ">
                        <p className="border-4 w-10 h-10 flex justify-center items-center text-gray-800 border-gray-300 rounded-full">
                            or
                        </p>
                    </div>

                    {/* Right column */}
                    <div className="lg:pl-8 flex flex-col lg:items-center w-full">
                        {/* Heading */}
                        <h2 className="text-2xl font-bold mb-4 sm:mb-6 text-left lg:text-center">
                            Create an account
                        </h2>

                        {/* Register Button */}
                        <button
                            type="button"
                            className="flex items-center justify-center gap-2 bg-gray-100 hover:bg-gray-200 text-blue-900 font-semibold text-[15px] sm:text-base px-6 py-3 w-full sm:w-11/12 mx-auto rounded border border-gray-300 transition-all duration-200"
                        >
                            <FaUserPlus className="w-5 h-5" />
                            <span>Register for an account</span>
                        </button>
                    </div>
                </div>
            </div>
        </section>
    );
}
