import React from 'react';

const FooterCommon = () => {
    return (
        <>
            {/* Footer */}
            <div className="w-full mt-4">
                {/* Gray section with links */}
                <div className="bg-[#e5e7eb] border-t border-[#ccc] hidden lg:block">
                    <div
                        className="
              max-w-7xl mx-auto
              flex flex-col md:flex-row
              justify-start md:items-start
              gap-8 md:gap-24
              text-sm text-[#333] px-6 py-6
            "
                    >
                        {/* About */}
                        <div>
                            <h3 className="font-bold mb-2 text-lg ">About</h3>
                            <div className="space-y-3">
                                <a href="#" className="block text-[#335075] hover:underline">
                                    About GCKey
                                </a>
                                <a href="#" className="block text-[#335075] hover:underline">
                                    Enabled Services
                                </a>
                                <a href="#" className="block text-[#335075] hover:underline">
                                    Site Map
                                </a>
                            </div>
                        </div>

                        {/* Transparency */}
                        <div>
                            <h3 className="font-bold mb-2 text-lg">Transparency</h3>
                            <div className="space-y-3">
                                <a href="#" className="block text-[#335075] hover:underline">
                                    Proactive Disclosure
                                </a>
                                <a href="#" className="block text-[#335075] hover:underline">
                                    Terms and Conditions
                                </a>
                            </div>
                        </div>

                        {/* Contact Us */}
                        <div>
                            <h3 className="font-bold mb-2 text-lg">Contact Us</h3>
                            <div className="space-y-3">
                                <a href="#" className="block text-[#335075] hover:underline text-sm">
                                    Phone Numbers
                                </a>
                            </div>
                        </div>
                    </div>
                </div>

                {/* Thin blue line */}
                <div className="border-b-[3px] border-[#2d4a72]"></div>

                {/* Canada Wordmark */}
                <div className="bg-white max-w-7xl px-4 mx-auto py-6 flex justify-end md:justify-end">
          <span className="relative text-5xl font-serif font-bold text-black leading-none">
            Canada
              {/* Stylized red flag above the 'a' */}
              <span className="absolute -top-2 right-[-8px] inline-block">
              <img
                  src="https://upload.wikimedia.org/wikipedia/commons/d/d9/Flag_of_Canada_%28Pantone%29.svg"
                  alt="Canada Flag"
                  className="w-7 h-7"
              />
            </span>
          </span>
                </div>
            </div>
        </>
    );
};

export default FooterCommon;
