import React from "react";

const NavbarCommon = () => {
    return (
        // The <header> tag is more semantic for a navigation bar.
        <header className=" py-3 bg-white">
            {/* Main container for top content */}
            <div className="max-w-7xl mx-auto px-4 py-3">
                <div className="flex flex-wrap items-center justify-between">

                    <div className="flex justify-between   w-full lg:w-auto">
                        {/* Using an anchor tag for the logo is standard practice */}
                        <a href="/">
                            <img
                                // This is the official combined logo SVG used by the GoC website
                                src="https://www.canada.ca/etc/designs/canada/wet-boew/assets/sig-blk-en.svg"
                                alt="Government of Canada"
                                className="h-7 md:h-8 w-auto" // Slightly larger on medium screens
                            />
                        </a>
                        {/* Language switcher */}
                        <a
                            href="#"
                            className="text-[#2d4a72]  underline text-sm   whitespace-nowrap"
                        >
                            <span className="md:hidden text-lg font-bold" title="Français">FR</span>
                        </a>
                    </div>

                    {/* Right side: Language and Search */}
                    <div className="flex items-end flex-col space-x-4 mt-4 w-full md:mt-0 md:w-auto">



                        {/*/!* Search form *!/*/}
                        {/*<form className="flex-grow md:flex-grow-0">*/}
                        {/*    <div className="flex">*/}
                        {/*        <label htmlFor="search-ircc" className="sr-only">*/}
                        {/*            Search IRCC*/}
                        {/*        </label>*/}
                        {/*        <input*/}
                        {/*            id="search-ircc"*/}
                        {/*            type="search"*/}
                        {/*            placeholder="Search IRCC"*/}
                        {/*            // Styling for the input field to match the image*/}
                        {/*            className="w-full px-2 py-1 text-sm border border-gray-600 focus:outline-none focus:ring-2 focus:ring-blue-500"*/}
                        {/*        />*/}
                        {/*        <button*/}
                        {/*            type="submit"*/}
                        {/*            // Using a more accurate color for the button*/}
                        {/*            className="bg-[#335075] p-2 hover:bg-[#243850]"*/}
                        {/*        >*/}
                        {/*            <svg*/}
                        {/*                xmlns="http://www.w3.org/2000/svg"*/}
                        {/*                className="h-4 w-4 text-white"*/}
                        {/*                fill="none"*/}
                        {/*                viewBox="0 0 24 24"*/}
                        {/*                stroke="currentColor"*/}
                        {/*            >*/}
                        {/*                <path*/}
                        {/*                    strokeLinecap="round"*/}
                        {/*                    strokeLinejoin="round"*/}
                        {/*                    strokeWidth={2}*/}
                        {/*                    d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"*/}
                        {/*                />*/}
                        {/*            </svg>*/}
                        {/*            <span className="sr-only">Search</span>*/}
                        {/*        </button>*/}
                        {/*    </div>*/}
                        {/*</form>*/}
                    </div>
                </div>
            </div>

            {/* Bottom Section with Menu Button */}
            {/*<div>*/}
            {/*    /!* The dark horizontal line seen in the screenshots *!/*/}
            {/*    <div className="h-1 bg-[#335075]"></div>*/}
            {/*    Container to position the Menu button correctly*/}
            {/*    <div className="max-w-7xl mx-auto px-4">*/}
            {/*        <button className="bg-[#335075] text-white font-bold text-sm px-4 py-3 flex items-center space-x-2 -mt-1 hover:bg-[#243850]">*/}
            {/*            <span>MENU</span>*/}
            {/*            <svg*/}
            {/*                className="w-4 h-4"*/}
            {/*                fill="none"*/}
            {/*                stroke="currentColor"*/}
            {/*                strokeWidth="2"*/}
            {/*                viewBox="0 0 24 24"*/}
            {/*            >*/}
            {/*                <path strokeLinecap="round" strokeLinejoin="round" d="M19 9l-7 7-7-7" />*/}
            {/*            </svg>*/}
            {/*        </button>*/}
            {/*    </div>*/}
            {/*</div>*/}
        </header>
    );
};

export default NavbarCommon;